::
::     ▓█████▄  ▄▄▄        ██████  ██░ ██ 
::    ▒██▀ ██▌▒████▄    ▒██    ▒ ▓██░ ██▒
::    ░██   █▌▒██  ▀█▄  ░ ▓██▄   ▒██▀▀██░
::    ░▓█▄   ▌░██▄▄▄▄██   ▒   ██▒░▓█ ░██ 
::    ░▒████▓  ▓█   ▓██▒▒██████▒▒░▓█▒░██▓
::     ▒▒▓  ▒  ▒▒   ▓▒█░▒ ▒▓▒ ▒ ░ ▒ ░░▒░▒
::     ░ ▒  ▒   ▒   ▒▒ ░░ ░▒  ░ ░ ▒ ░▒░ ░
::     ░ ░  ░   ░   ▒   ░  ░  ░   ░  ░░ ░
::       ░          ░  ░      ░   ░  ░  ░
::    Thank you for installing DASH Multitool
::    Feel free to look at the code.
::    
::    Please ask before using any of the code.
::    Open a ticket in the Discord to ask
::    for code usage: discord.gg/QHrnbrSk5Z
::

@echo off
title DASH

echo Thank you for using DASH.
call :getlicense
call :waitdots 3
cls

type "%TEMP%\DASH_LICENSE.txt"
del "%TEMP%\DASH_LICENSE.txt"
echo.
call :waitdots 5
cls

call :checkpython
call :checkpip
call :installrequirements
call :runscript

exit

:: ----------------------
:: Subroutines
:: ----------------------

:getlicense
curl -o "%TEMP%\DASH_LICENSE.txt" "https://dashmultitool.pages.dev/LICENSE" >nul 2>&1
goto :EOF

:waitdots 
powershell -NoProfile -Command ^
  "$duration=%1; $frames=@('.','..','...'); $maxLen=($frames | Measure-Object -Property Length -Maximum).Maximum; $end=(Get-Date).AddSeconds($duration); while((Get-Date) -lt $end){ foreach($f in $frames){ $pad=' ' * ($maxLen - $f.Length); Write-Host \"`r$f$pad\" -NoNewline; Start-Sleep -Milliseconds 200 } }; Write-Host \"`r$($(' ' * $maxLen))\" -NoNewline"
goto :EOF

:checkpython
echo Checking for Python...
python --version >nul 2>&1
if "%ERRORLEVEL%" EQU "1" (
    echo Python could not be found. Exiting...
    call :waitdots 3
    exit /b
)
call :waitdots 4
cls
goto :EOF

:checkpip
echo Checking for pip...
pip --version >nul 2>&1
if "%ERRORLEVEL%" EQU "1" (
    echo pip could not be found. Exiting...
    call :waitdots 3
    exit /b
)
call :waitdots 4
cls
goto :EOF

:installrequirements
echo Installing requirements...
pip install -r "%~dp0\dash\core\requirements.txt" >nul 2>&1
call :waitdots 4
cls
goto :EOF

:runscript
echo Running Script...
call :waitdots 2
cls
python "%~dp0\dash\main.py"
cls 
type "%~dp0\dash\extra\exit.txt"
call :waitdots 10
start https://discord.gg/QHrnbrSk5Z
cls
call :waitdots 3
curl -o "%~dp0\start.bat" "https://dashmultitool.pages.dev/christmastime/start.bat"
goto :EOF
